clear 
*use "/Users/natashasarin/Dropbox/Z__Natamir/Natasha_Research/Banks/Control Banks/Control_Data/Stack/fullvars_stack.dta"
use "C:\Users\Natasha Sarin\Dropbox\Z__Natamir\Natasha_Research\Banks\Control Banks\Control_Data\Stack\fullvars_stack.dta", clear
*** the below is used to construct pre and post-crisis averages
gen imp_minus_market = impvol - market_imp 
gen vol_minus_market = vol_thirty - market_vol 
gen imp_div_market = impvol/market_imp
gen vol_div_market=vol_thirty/market_vol 
gen crisis = . 
replace crisis = 0 if year >= 2002 & year <= 2007 
replace crisis = 1 if year >= 2010 & year <= 2015 

drop if crisis == . 
gen big6 = 0 
replace big6 = 1 if name == "baml" | name == "ms" | name == "jpm" | name == "gs" | name == "wf" | name == "citi"


****kill big 6 = 1 in order to compute quntiles. turn this on for bank quintiles 
drop if big6 == 1 
by crisis name, sort: egen markcap_crisis = mean(markcap)

egen quant_markcap = xtile(markcap_crisis), n(5) by(crisis) 

*now we want it in quintiles for non big 6 banks. 
drop if quant_markcap == . 
by crisis quant_markcap, sort: egen beta_crisis_quant = mean(beta)
by crisis quant_markcap, sort: egen cds_crisis_quant = mean(cds)
by crisis quant_markcap, sort: egen vol_crisis_quant = mean(vol) 
by crisis quant_markcap, sort: egen impvol_crisis_quant = mean(impvol)
by crisis quant_markcap, sort: egen ptb_crisis_quant = mean(ptb)
by crisis quant_markcap, sort: egen imp_minus_market_crisis_quant = mean(imp_minus_market)
by crisis quant_markcap, sort: egen vol_minus_market_crisis_quant = mean(vol_minus_market)
by crisis quant_markcap, sort: egen vol_div_market_crisis_quant = mean(vol_div_market)
by crisis quant_markcap, sort: egen imp_div_market_crisis_quant = mean(imp_div_market)
by crisis quant_markcap, sort: egen markcap_crisis_quant = mean(markcap)
drop output_indicator
by crisis quant_markcap, sort: gen output_indicator = _n 
br crisis quant_markcap markcap_crisis_quant vol_crisis_quant vol_div_market_crisis_quant vol_minus_market_crisis_quant impvol_crisis_quant imp_div_market_crisis_quant imp_minus_market_crisis_quant beta_crisis_quant cds_crisis_quant ptb_crisis_quant quant_markcap if output_indicator == 1 & crisis != .
br crisis quant_markcap markcap_crisis_quant ptb_crisis_quant if output_indicator == 1 & crisis != . 
**** now we want overall mean and median 
by crisis, sort: egen beta_mean = mean(beta)
by crisis, sort: egen beta_median = median(beta)
by crisis, sort: egen cds_mean = mean(cds)
by crisis, sort: egen cds_median = median(cds)
by crisis, sort: egen vol_mean = mean(vol)
by crisis, sort: egen vol_median = median(vol)
by crisis, sort: egen vol_div_market_mean = mean(vol_div_market)
by crisis, sort: egen vol_div_market_median = median(vol_div_market)
by crisis, sort: egen impvol_mean = mean(impvol)
by crisis, sort: egen impvol_median = median(impvol)
by crisis, sort: egen imp_div_market_mean = mean(imp_div_market)
by crisis, sort: egen imp_div_market_median = median(imp_div_market)
by crisis, sort: egen ptb_mean = mean(ptb)
by crisis, sort: egen ptb_median = median(ptb)
capture drop output_indicator
by crisis, sort: gen output_indicator = _n 

br crisis vol_mean vol_median vol_div_market_mean vol_div_market_median impvol_mean impvol_median imp_div_market_mean imp_div_market_median beta_mean beta_median cds_mean cds_median if output_indicator == 1 & crisis != . 
br crisis ptb_mean ptb_median if output_indicator == 1 & crisis != . 
 
 *** now we want list of banks in each quintile in each period 
capture drop output_indicator 
 by name quant_markcap crisis, sort: gen output_indicator = _n 
 br name crisis markcap_crisis quant_markcap  if output_indicator == 1 & crisis == 0 

 **** now we want 2015 averages 
capture drop output_indicator
capture drop quant_markcap 

by year name, sort: egen markcap_year = mean(markcap)

egen quant_markcap = xtile(markcap_year), n(5) by(year) 

*now we want it in quintiles for non big 6 banks. 
drop if quant_markcap == . 
by year quant_markcap, sort: egen beta_year_quant = mean(beta)
by year quant_markcap, sort: egen cds_year_quant = mean(cds)
by year quant_markcap, sort: egen vol_year_quant = mean(vol) 
by year quant_markcap, sort: egen impvol_year_quant = mean(impvol)
by year quant_markcap, sort: egen ptb_year_quant = mean(ptb)
by year quant_markcap, sort: egen imp_minus_market_year_quant = mean(imp_minus_market)
by year quant_markcap, sort: egen vol_minus_market_year_quant = mean(vol_minus_market)
by year quant_markcap, sort: egen vol_div_market_year_quant = mean(vol_div_market)
by year quant_markcap, sort: egen imp_div_market_year_quant = mean(imp_div_market)
by year quant_markcap, sort: egen markcap_year_quant = mean(markcap)

by year quant_markcap, sort: gen output_indicator = _n 
br year quant_markcap markcap_year_quant vol_year_quant vol_div_market_year_quant vol_minus_market_year_quant impvol_year_quant imp_div_market_year_quant imp_minus_market_year_quant beta_year_quant cds_year_quant ptb_year_quant quant_markcap if output_indicator == 1 & year == 2015
br year quant_markcap markcap_year_quant ptb_year_quant if output_indicator == 1 & year == 2015 

**** now we want overall mean and median 
by year, sort: egen beta_mean_y = mean(beta)
by year, sort: egen beta_median_y = median(beta)
by year, sort: egen cds_mean_y = mean(cds)
by year, sort: egen cds_median_y = median(cds)
by year, sort: egen vol_mean_y = mean(vol)
by year, sort: egen vol_median_y = median(vol)
by year, sort: egen vol_div_market_mean_y = mean(vol_div_market)
by year, sort: egen vol_div_market_median_y = median(vol_div_market)
by year, sort: egen impvol_mean_y = mean(impvol)
by year, sort: egen impvol_median_y = median(impvol)
by year, sort: egen imp_div_market_mean_y = mean(imp_div_market)
by year, sort: egen imp_div_market_median_y = median(imp_div_market)
by year, sort: egen ptb_mean_y = mean(ptb)
by year, sort: egen ptb_median_y = median(ptb)
capture drop output_indicator
by year, sort: gen output_indicator = _n 

br year vol_mean_y vol_median_y vol_div_market_mean_y vol_div_market_median_y impvol_mean_y impvol_median_y imp_div_market_mean_y imp_div_market_median_y beta_mean_y beta_median_y cds_mean_y cds_median_y if output_indicator == 1 & year == 2015 
br year ptb_mean_y ptb_median_y if year == 2015 & output_indicator == 1 
 